package Kephra::Config::Embedded;
our $VERSION = '0.13';

#   complete set of config to be able to start app under all circumstances


use strict;


sub get_global_settings{
	return {
		about => {
			purpose => 'build in global settings',
			version => $Kephra::VERSION,
		},
		app => {
			commandlist => {
				cache => {
					file => 'interface/cache/commands.conf',
					'use' => 1,
				},
				file => 'interface/commands.conf',
				node => 'commandlist',
			},
			contextmenu => {
				defaultfile => 'interface/contextmenus.yml',
				id => {
					document_context => 'editpanel_contextmenu',
					document_list => '&document_list',
					document_selection => 'textselection_contextmenu',
					status_eol => 'document_lineendchar_contextmenu',
					status_syntaxmode => 'document_syntaxstyle_contextmenu',
					status_tab => 'document_whitespace_contextmenu',
					toolbar_search => 'searchbar_contextmenu',
				},
			},
			error_output => 'dialog',
			iconset_path => 'icon/set/jenne/',
			localisation_file => 'localisation/deutsch_iso.conf',
			menubar => {
				file => 'interface/mainmenu.yml',
				node => 'full_menubar',
			},
			statusbar => {
				interactive => 1,
				msg_nr => 0,
				visible => 1,
			},
			tabbar => {
				button => {
					'close' => 1,
					new => 0,
				},
				contextmenu => 'document_list',
				contextmenu_use => 1,
				file_info => 'name',
				info_symbol => 1,
				insert => 'rightmost',
				mark_configs => 1,
				max_tab_width => 25,
				middle_click => 'file-close',
				number_tabs => 0,
				seperator_line => 1,
				switch_back => 1,
				visible => 1,
			},
			toolbar => {
				all => {
					responsive => 1,
					defaultfile => 'interface/appbars.yml',
				},
				main => {
					contextmenu => 0,
					file => 'interface/appbars.yml',
					node => 'main_toolbar',
					size => 16,
					visible => 1,
				},
				search => {
					autofocus => 1,
					autohide => 0,
					contextmenu => 'toolbar_search',
					file => 'interface/appbars.conf',
					node => 'searchbar',
					position => 'bottom',
					visible => 1,
				},
			},
			window => {
				default => {
					position_x => 0,
					position_y => 0,
					size_x => 'full_screen',
					size_y => 'full_screen',
					title => "$path $vnr",
				},
				icon => 'icon/app/proton.ico',
				max_number => 1,
				position_x => 10,
				position_y => 10,
				save_position => 1,
				size_x => 660,
				size_y => 531,
				'stay_on_top' => 0,
				title => "$path $vnr",
			},
			xp_style => 1,
		},
		dialogs => {
			button_handing => 'right',
			search => {
				save_position => 1,
				position_y    => 100,
				position_x    => 100,
				tooltips      => 1,
			},
			config => {
				save_position => 1,
				position_y    => 100,
				position_x    => 100,
				tooltips      => 1,
			},
		},
		editpanel => {
			DND_mode       => 'copy',
			auto => {
				brace => {
					glue_tangent => 0,
					indention => 1,
					'join' => 1,
					make => 1,
				},
				indention = 1,
			},
			contextmenu => {
				file    => 'xrc/pce_contextmenu_deutsch.xrc',
				node    => 'pce_contextmenu_deutsch',
				visible => 'custom',
			},
			font => {
				family => 'Courier New',
				size   => 10,
				style  => 'normal',
				weight => 'normal',
			},
			history => {
				fast_undo_steps => '7',
			},
			indicator => {
				bracelight => {
					bad_color  => 'ff0000',
					good_color => '0000ff',
					mode       => 'adjacent',
					visible    => 1,
				},
				caret => {
					color  => '0000ff',
					period => 500,
					width  => 2
				},
				caret_line => {
					color   => 'eeeed7',
					visible => 1,
				},
				end_of_line_marker => 0,
				indent_guide => {
					visible => 1,
					color   => 'bbbbbb',
				},
				right_margin => {
					color    => 'ccccff',
					position => 80,
					style    => 1
				},
				selection => {
					back_color => '001177',
					fore_color => 'f3f3f3'
				},
				whitespace => {
					color   => 'cccc99',
					visible => 1,
				},
			},
			line_wrap => 0,
			margin => {
				fold => 0,
				linenumber => {
					autosize   => 1,
					back_color => 'f5f5eb',
					fore_color => '0,0,0',
					min_width  => 4,
					width      => 4,
					visible    => 1,
				},
				marker => {
					back_color => '0022ff',
					fore_color => '000055',
					visible    => 0
				},
				text => 4
			},
			scroll_width => '640',
		},
		file => {
			current => {
				directory => '/kephra/config/global/',
				'open'    => [],
			},
			defaultsettings => {
				codepage    => 0,
				cursorpos   => 0,
				EOL_open    => 'auto',
				EOL_new     => 'cr+lf',
				readonly    => 'protect',
				syntaxstyle => 'auto',
				tab_size    => '4',
				tab_use     => 0,
			},
			endings => {
				ada     => 'ada ads adb',
				as      => 'as',
				asm     => 's asm',
				conf    => 'conf',
				context => 'tuo sty',
				cpp     => 'c cc cpp cxx h',
				cs      => 'cs',
				css     => 'css',
				eiffel  => 'e',
				forth   => 'forth',
				fortran => 'f for f77 f90 f95 f2k',
				haskell => 'hs',
				html    => 'htm html ssi shtml xhtml tag stag',
				java    => 'jav java',
				js      => 'js',
				idl     => 'idl odl',
				latex   => 'aux toc idx',
				lisp    => 'el jl lsp lisp',
				lua     => 'lua',
				nsis    => 'nsi nsh',
				perl    => 'pl ple plx plex pm pod cgi',
				php     => 'php php3 php4 phtml',
				ps      => 'ps',
				pascal  => 'pas dpr dpk dfm inc pp',
				python  => 'py pyw',
				ruby    => 'rb',
				scheme  => 'scm smd ss',
				sh      => 'bsh sh',
				sql     => 'sql',
				tcl     => 'tcl tk itk',
				tex     => 'tex sty',
				text    => 'txt ini nfo cfg',
				vb      => 'vb bas frm cls ctl pag dsr dob',
				vbs     => 'vbs dsm',
				xml     => 'xml xsl svg xul xsd dtd xslt axl xrc rdf',
				yaml    => 'yaml yml',
			},
			group => {
				config => 'conf',
				perl   => 'perl',
				text   => 'text',
				web    => 'css html php perl js',
			},
			history => {
				'length' => 7,
				path => [],
			},
			'open' => {
				dir_recursive       => 1,
				each_once           => 1,
				in_current_dir      => 1,
				into_empty_doc      => 1,
				into_only_empty_doc => 1,
				only_text           => 1,
				single_doc          => 0,
			 },
			save => {
				auto_save     => 0,
				b4_quit       => 'ask',
				b4_close      => 'ask',
				change_doc    => 0,
				empty         => 0,
				on_leave      => 0,
				overwrite     => 'ask',
				reload_config => 1,
				tilde_backup  => 0,
				timer         => '20',
				unchanged     => 0,
				unchanged_all => 0,
			}
			session => {
				autosave  => 'extern',
				backup    => 'backup.conf',
				current   => 'current.conf',
				directory => 'session/',
				node      => 'files',
			},
			templates => {
				directory => 'templates/',
				file      => 'perl.conf',
			},
		},
		search => {
			attribute => {
				match_regex      => 0,
				auto_wrap        => 1,
				match_case       => 0,
				match_word_begin => 0,
				fast_steps       => 7,
				match_whole_word => 0,
				incremental      => 1,
			},
			history => {
				'length' => 12,
				remember_only_matched => 1,
				save => 1,
				'use' => 1,
			}
		},
		texts => {
			special    => 'english/special_feature.txt',
			credits    => 'english/license/credits.txt',
			feature    => 'english/all_feature.txt',
			keymap     => 'english/keymap.txt',
			license    => 'english/license/gpl.txt',
			navigation => 'english/navigation.txt',
			version    => 'english/this_version.txt',
			welcome    => 'english/welcome.txt',
		}
	}
}


sub get_command_list{ 
	return {
	} 
}

sub get_interface_settings{ 
	return {
	} 
}


sub get_english_localisation {
	return {
		about => {
			language => 'english',
			iso_code => 'en',
			coding  => '8bit',
			purpose => 'embedded emergency localisation',
		},
		app => {
			menu => {
				file => 'File',
				file_insert_templates => 'Templates',
				file_history => 'Recent',
				file_session => 'Session',
				edit => 'Edit',
				edit_history => 'History',
				current_line => 'Line',
				selection => 'Selection',
				selection_format => 'Format',
				selection_comment => 'Comment',
				selection_convert => 'Convert',
				search => 'Search',
				search_attributes => 'Attributes',
				find_functions => 'Find Functions',
				replace_functions => 'Replace Functions',
				goto_bookmark => 'Goto Bookmark',
				toggle_bookmark => 'Toggle Bookmark',
				document => 'Document',
				'&document_list' => 'Select',
				document_syntaxmode => 'Syntaxmode',
				'document_syntaxmode_A-M' => 'A - M',
				'document_syntaxmode_N-Z' => 'N - Z',
				document_syntaxmode_compiled => 'Compiled',
				document_syntaxmode_interpreted => 'Interpreted',
				document_syntaxmode_data_structure => 'Data Structure',
				document_syntaxmode_document => 'Documents',
				document_syntaxmode_web => 'Webprogramming',
				document_syntaxmode_special => 'Special',
				document_tab_width => 'Tab Width',
				document_lineendchar => 'Lineendchars',
				document_readonly => 'Write Protection',
				view => 'View',
				view_contexmenu => 'Contextmenu',
				view_textmargin => 'Text Margin',
				config => 'Config',
				config_app_lang => 'Language',
				config_global => 'Global Config File',
				config_interface => 'User Interface',
				config_localisation => 'Localisation',
				'config_syntaxmode_A-M' => 'Syntaxmodes A - M',
				'config_syntaxmode_N-Z' => 'Syntaxmodes N - Z',
				help => 'Help'
			},
			status => {
				chars => 'Chars',
				cloumn => 'Column',
				'line' => 'Line',
				lines => 'Lines',
				selection => 'Selection',
				soft_tabs => 'soft tabs',
				hard_tabs => 'hard tabs',
				now_is => 'Now is',
				last_change => 'Last change',
				date => 'Date',
				'time' => 'Time',
			},
			tabbar => {
				untitled => 'untitled'
			},
		},
		commandlist => {
			label => {
				app => {
					'exit' => 'Exit',
				},
				file => {
					new => 'New',
					'open' => 'Open ...',
					reload => 'Reload',
					'reload-all' => 'Reload All',
					'rename' => 'Rename ...',
					insert => 'Insert ...',
					'close' => 'Close',
					'close-all' => 'Close All',
					'close-other' => 'Close Other',
					save => 'Save',
					'save-all' => 'Save All',
					'save-as' => 'Save As ...',
					'save-copy-as' => 'Save Copy ...',
					session => {
						'open' => 'Open ...',
						add => 'Add ...',
						save => 'Save ...',
						import => 'Import ...',
						export => 'Export ...',
						'backup-open' => 'Restore Backup',
						backup-save => 'Save Backup',
					},
				},
				'edit' => {
					'records' => {
						'undo' => 'Undo',
						'redo' => 'Redo',
						'undo-several' => 'Fast Undo',
						'redo-several' => 'Fast Redo',
						'goto-begin' => 'Jump To Begin',
						'goto-end' => 'Jump To End',
						'delete' => 'Clear Records',
					},
					'cut' => 'Cut',
					'copy' => 'Copy',
					'paste' => 'Paste',
					'replace' => 'Replace',
					'delete' => 'Delete',
					'delete-tab' => 'Del Tab',
					'line' => {
						'cut' => 'Cut',
						'copy' => 'Copy',
						duplicate => 'Duplicate',
						'replace' => 'Replace',
						'delete' => 'Delete',
						'delete-left' => 'Delete Left',
						'delete-right' => 'Delete Right',
						'move' => {
							'line-up' => 'Move Line Up',
							'line-down' => 'Move Line Down',
							'page-up' => 'Move Page Up',
							'page-down' => 'Move Page Down',
						},
					},
					'selection' => {
						'convert' => {
							uppercase => 'Uppercase',
							lowercase => 'Lowercase',
							titlecase => 'Titlecase',
							sentencecase => 'Sentencecase',
							spaces2tabs => 'Spaces To Tabs',
							tabs2spaces => 'Tabs To Spaces',
						},
						comment => {
							'add-perl' => 'Add Perl Style Comment',
							'del-perl' => 'Remove Perl Style Comment',
							'toggle-perl' => 'Toggle Perl Style Comment',
							'add-c' => 'Add C Style Comment',
							'del-c' => 'Remove C Style Comment',
							'add-xml' => 'Add XML Style Comment',
							'del-xml' => 'Remove XML Style Comment',
						},
						'format' => {
							'align-on-begin' => 'Align On Begin',
							'block-on-right-margin' => 'Blockformat On Right Margin',
							'block-on-width' => 'Blockformat On Width ...',
							'linewrap-on-right-margin' => 'Linebreaks On Right Margin',
							'linewrap-on-width' => 'Linebreaks On Width ...',
							'indent-char' => 'Indent Space',
							'dedent-char' => 'Dedent Space',
							'indent-tab' => 'Indent Tab',
							'dedent-tab' => 'Dedent Tab',
							'del-trailing-whitespace' => 'Delete Trailing Space',
							'join-lines' => 'Join Lines',
						},
						'move' => {
							'char-left' => 'Move Left',
							'char-right' => 'Move Right',
							'line-up' => 'Move Up',
							'line-down' => 'Move Down',
							'page-up' => 'Move Page Up',
							'page-down' => 'Move Page Down',
						},
					},
					'document' => {
						convert => {
							indent2spaces => 'Indention 2 Whitespace',
							indent2tabs => 'Indention 2 Tab',
							spaces2tabs => 'Spaces 2 Tabs',
							tabs2spaces => 'Tabs 2 Whitespace',
						},
						'format' => {
							'del-trailing-whitespace' => 'Delete Trailing',
						},
					},
				},
				'select' => {
					'document' => 'Select All',
					'to-block-begin' => '',
					'to-block-end' => '',
				},
				'search' => {
					'attribute' => {
						'autowrap-switch' => 'Auto Wrap',
						'incremental-switch' => 'Incremental Search',
						'regex-switch' => 'Regular Expression',
						'match' => {
							'case-switch' => 'Match Case',
							'whole-word-switch' => 'Whole Word only',
							'word-begin-switch' => 'Word Begin',
						},
					},
					'range' => {
						selection => 'Selection',
						document => 'Document',
						'open-docs' => 'Open Documents'
					},
				},
				find => {
					prev => 'Find Previous',
					'next' => 'Find Next',
					first => 'Find First',
					'last' => 'Find Last',
					selection => 'Find Selection',
					'mark-all' => 'Mark all Matches',
				},
				replace => {
					prev => 'Replace Backward',
					'next' => 'Replace Forward',
					all => 'Replace All',
					'with-confirm' => 'Replace With Confirm',
					selection => 'Replace Selection',
				},
				'goto' => {
					'last-edit' => 'Goto Last Edit',
					'line-nr' => 'Goto Line Number  ...',
				},
				bookmark => {
					'goto' => {
						1 => 1,
						2 => 2,
						3 => 3,
						4 => 4,
						5 => 5,
						6 => 6,
						7 => 7,
						8 => 8,
						9 => 9,
						0 => '0',
					},
					toggle => {
						1 => 1,
						2 => 2,
						3 => 3,
						4 => 4,
						5 => 5,
						6 => 6,
						7 => 7,
						8 => 8,
						9 => 9,
						0 => '0',
					},
					'delete-all' => 'Delete Bookmarks',
				},
				document => {
					'auto-indention' => 'Autoindention',
					'brace-indention' => 'Braceindention',
					'brace-light' => 'Bracelight',
					EOL => {
						auto => 'Align',
						'cr+lf' => 'CR+LF (Windows)',
						cr => 'CR (Macintosh)',
						lf => 'LF (Linux)',
					},
					change => {
						back => 'Switch Back',
						prev => 'Previous Tab',
						'next' => 'Next Tab',
					},
					readonly => {
						'as-attr' => 'As Attribute',
						'on' => 'Always On',
						'off' => 'Always Off',
					},
					syntaxmode => {
						auto => 'Autoselect',
						none => 'None',
						ada => 'Ada',
						as => 'Actionscript',
						asm => 'Assembler',
						c => 'C / C++',
						conf => 'Conf',
						context => 'Context',
						cs => 'C\#',
						css => 'CSS',
						eiffel => 'Eiffel',
						forth => 'Forth',
						fortran => 'FORTRAN',
						html => 'HTML',
						idl => 'IDL',
						java => 'Java',
						js => 'Javascript',
						latex => 'LaTeX',
						lisp => 'LISP',
						lua => 'Lua',
						nsis => 'NSIS',
						pascal => 'Pascal',
						perl => 'Perl',
						php => 'PHP',
						ps => 'Postscript',
						python => 'Python',
						ruby => 'Ruby',
						scheme => 'Scheme',
						sh => 'UNIX Shell',
						sql => 'SQL',
						tcl => 'TCL',
						tex => 'TeX',
						vb => 'Visual Basic',
						vbs => 'VB Script',
						xml => 'XML',
						yaml => 'YAML',
					},
					tabs => {
						hard => 'Tabs (HT => "hard tabs")',
						soft => 'Spaces (ST => "soft tabs")',
						'use' => 'Use Tabs',
						width => {
							2 => 2,
							3 => 3,
							4 => 4,
							5 => 5,
							6 => 6,
							8 => 8,
						},
					},
				},
				view => {
					dialog => {
						find => 'Search Dialog',
						replace => 'Replace Dialog',
						info => 'About ...',
						keymap => 'Keymap ...',
					},
					documentation => {
						credits => 'Credits',
						'feature-list' => 'Featurelist',
						'navigation-guide' => 'Navigation Guide',
						welcome => 'Welcome',
						'this-version' => 'This Version',
					},
					editpanel => {
						EOL => 'Lineend Marker',
						'caret-line' => 'Caret Line',
						font => 'Font',
						'indention-guide' => 'Indention Guide',
						'line-wrap' => 'Line Wrap',
						'right-margin' => 'Right Margin',
						whitespace => 'Whitespace',
						contextmenu => {
							custom => 'Custom',
							default => 'Default',
							'no' => 'No Menu',
						},
						margin => {
							marker => 'Marker Margin',
							'line-number' => 'Line Number',
							text => {
								0 => '0 px',
								1 => 1,
								2 => 2,
								4 => 4,
								6 => 6,
								8 => 8,
								10 => 10,
								12 => 12,
							},
						},
					},
					statusbar => 'Statusbar',
					'statusbar-contexmenu' => 'Statuscontext',
					tabbar => 'Tabbar',
					toolbar => {
						main => 'Main Toolbar',
						search => 'Searchbar',
						'search-goto' => 'Searchbar',
					},
					'window-stay-on-top' => 'Stay On Top',
				},
				config => {
					'app-lang' => {
						english => 'English',
						'deutsch-iso' => 'Deutsch (ISO)',
						'deutsch-utf' => 'Deutsch (UTF)',
						deutsch => 'Deutsch',
						'cesky-utf' => 'Cesky',
					},
					file => {
						global => {
							'open' => 'Open',
							reload => 'Reload',
							'load-from' => 'Load From ...',
							'load-backup' => 'Load Backup',
							'load-defaults' => 'Load Defaults',
							merge => 'Merge With ...',
							save => 'Save',
							'save-as' => 'Save As ...',
						},
						interface => {
							commandlist => 'Command List',
							menubar => 'Main Menu',
							contextmenu => 'Contextmenus',
							maintoolbar => 'Main Toolbar',
							searchbar => 'Searchbar',
							statusbar => 'Statusbar',
						},
						localisation => {
							english => 'English',
							deutsch => 'Deutsch',
							'deutsch-iso' => 'Deutsch (ISO)',
							'deutsch-utf' => 'Deutsch (UTF)',
							'cesky-utf' => 'Cesky (UTF)',
						},
						syntaxmode => {
							ada => 'Ada',
							as => 'Actionscript',
							asm => 'Assembler',
							c => 'C / C++',
							conf => 'Conf',
							context => 'Context',
							cs => 'C\#',
							css => 'CSS',
							eiffel => 'Eiffel',
							forth => 'Forth',
							fortran => 'FORTRAN',
							html => 'HTML',
							idl => 'IDL',
							java => 'Java',
							js => 'Javascript',
							latex => 'LaTeX',
							lisp => 'LISP',
							lua => 'Lua',
							nsis => 'NSIS',
							pascal => 'Pascal',
							perl => 'Perl',
							php => 'PHP',
							ps => 'Postscript',
							python => 'Python',
							ruby => 'Ruby',
							scheme => 'Scheme',
							sh => 'UNIX Shell',
							sql => 'SQL',
							tcl => 'TCL',
							tex => 'TeX',
							vb => 'Visual Basic',
							vbs => 'VB Script',
							xml => 'XML',
							yaml => 'YAML',
						},
						Templates => 'Templates',
					},
				},
			},
			help => {
				app => {
					'exit' => 'Exit',
				},
				file => {
					new => 'opens a new empty text',
					'open' => 'display an existing textfile as a new document',
					reload => 'read file from hard drive and replace content with displayed',
					'reload-all' => 'reload all opened files',
					'rename' => 'change current files name',
					insert => 'insert file content at caret position',
					'close' => 'close current document, if preset the file will be saved',
					'close-all' => 'close all open documents',
					'close-other' => 'close all open documents but not the current visible',
					save => 'save the displayed state of the current file',
					'save-all' => 'save all the currently opened files',
					'save-as' => 'save current document under different file name',
					'save-copy-as' => 'save doc with different name, keep current version open',
					session => {
						'open' => 'restore an once saved file session',
						add => 'add files of a saved file session',
						save => 'save order and properties of this file session',
						import => 'open files session from another editors format',
						export => 'save files session in another editors format',
						'backup-open' => 'restore the backup session',
						backup-save => 'remember current files as the backup session',
					},
				},
				edit => {
					records => {
						undo => 'mache letzte nderung im Dokument rckgngig',
						'redo' => 'zuletzt rckgngig gemachte nderung wiederholen',
						'undo-several' => 'mache mehrere nderungen rckgngig',
						'redo-several' => 'bringe mehrere nderungen wieder',
						'goto-begin' => 'bringe Zustand vor allen nderungen zurck',
						'goto-end' => 'hole alle gemachte nderungen wieder',
						'delete' => 'lsche alle Aufzeichnungen ber nderungen',
					},
					cut => 'cut selected text and store it in the clipboard',
					copy => 'copy selected text to the clipboard',
					paste => 'insert text from the clipboard',
					replace => 'replace selected text with the clipboard',
					'delete' => 'delete and forget selected text',
					'line' => {
						cut => 'cut current line and store it in the clipboard',
						copy => 'copy current line to the clipboard',
						duplicate => 'insert below a copy of the current line',
						replace => 'replace current line with the clipboard',
						'delete' => 'delete and forget current line',
						'delete-left' => 'delete left side from textcursor of current line',
						'delete-right' => 'delete right side from textcursor of current line',
						move => {
							'line-up' => 'move current line one line up',
							'line-down' => 'move current line one line down',
							'page-up' => 'move current line one page up',
							'page-down' => 'move current line one page down',
						},
					},
					selection => {
						convert => {
							uppercase => 'turn selected text to uppercase',
							lowercase => 'turn selected text to lowercase',
							titlecase => 'turn first char of every word uppercase',
							sentencecase => 'turn first char of every sentence uppercase',
							spaces2tabs => 'convert groups of whitespace to tabs',
							tabs2spaces => 'depends on current tab width',
						},
						comment => {
							'add-perl' => 'insert \# after every indention',
							'del-perl' => 'remove all \# following the indention',
							'toggle-perl' => 'comment all uncommented lines and vici versa',
							'add-c' => 'surround selection with /* and */',
							'del-c' => 'remove all /* and */ in the selection',
							'add-xml' => 'surround selection with  <!-- and -->',
							'del-xml' => 'remove all <!-- and --> in the selection',
						},
						'format' => {
							'align-on-begin' => 'align line indentions on first line',
							'block-on-right-margin' => 'format to textblock, that not cross right margin',
							'block-on-width' => 'format to textblock with chosen width ...',
							'linewrap-on-right-margin' => 'split lines before right margin',
							'linewrap-on-width' => 'split lines before chosen width ...',
							'indent-char' => 'increase indention of the selected lines by 1',
							'dedent-char' => 'decrease indention of the selected lines by 1',
							'indent-tab' => 'increase indention by current tab size',
							'dedent-tab' => 'decrease indention by current tab size',
							'del-trailing-whitespace' => 'delete whitespace on line endings',
							'join-lines' => 'delete end of line (EOL) symbols',
						},
						move => {
							'char-left' => 'move selection one character left',
							'char-right' => 'move selection one character right',
							'line-up' => 'move selection one line up',
							'line-down' => 'move selection one line down',
							'page-up' => 'move selection one page up',
							'page-down' => 'move selection one page down',
						},
					},
					document => {
						convert => {
							indent2spaces => 'convert tabs between linestart and first word',
							indent2tabs => 'convert spaces between linestart and first word',
							spaces2tabs => 'convert all spaces to tabs in the current doc',
							tabs2spaces => 'convert all tabs to spaces in the current doc',
						},
						'format' => {
							'del-trailing-whitespace' => 'delete all trailing whitespace',
						},
					},
				},
				'select' => {
					document => 'select entire document',
					'to-block-begin' => '',
					'to-block-end' => '',
				},
				search => {
					attribute => {
						'autowrap-switch' => 'Auto Wrap',
						'incremental-switch' => 'Incremental Search',
						'regex-switch' => 'Regular Expression',
						match => {
							'case-switch' => 'Match Case',
							'whole-word-switch' => 'Whole Word only',
							'word-begin-switch' => 'Word Begin',
						},
					},
					'range' => {
						selection => 'search and replace only within selected text',
						document => 'search and replace in whole current document',
						'open-docs' => 'search and replace in all open documents',
					},
				},
				find => {
					prev => 'find the previous match of the textsearch',
					'next' => 'find the next match of the textsearch',
					first => 'find first textsearch match in document',
					'last' => 'find last textsearch match in document',
					selection => 'remember selected text as current search item',
				},
				replace => {
					prev => 'replace selection and find previous match',
					'next' => 'replace selection and find next match',
					all => 'replace all matches in current search range',
					'with-confirm' => 'confirm or reject to replace every particular match',
					selection => 'remember selected text as current replace item',
				},
				'goto' => {
					'last-edit' => 'jump to position of last change in this document',
					'line-nr' => 'jump to line with chosen number',
				},
				bookmark => {
					'goto' => {
						1 => 'go to bookmark number 1',
						2 => 'go to bookmark number 2',
						3 => 'go to bookmark number 3',
						4 => 'go to bookmark number 4',
						5 => 'go to bookmark number 5',
						6 => 'go to bookmark number 6',
						7 => 'go to bookmark number 7',
						8 => 'go to bookmark number 8',
						9 => 'go to bookmark number 9',
						0 => 'go to bookmark number 0',
					},
					toggle => {
						1 => 'set here or remove (if present) bookmark 1',
						2 => 'set here or remove (if present) bookmark 2',
						3 => 'set here or remove (if present) bookmark 3',
						4 => 'set here or remove (if present) bookmark 4',
						5 => 'set here or remove (if present) bookmark 5',
						6 => 'set here or remove (if present) bookmark 6',
						7 => 'set here or remove (if present) bookmark 7',
						8 => 'set here or remove (if present) bookmark 8',
						9 => 'set here or remove (if present) bookmark 9',
						0 => 'set here or remove (if present) bookmark 0',
					},
					'delete-all' => 'delete all bookmarks',
				},
				document => {
					'auto-indention' => 'indents new line like previous when Enter pressed ',
					'brace-indention' => 'obey right indention after curly braces when press enter',
					'brace-light' => 'highlights associated pairs of braices',
					EOL => {
						auto => 'make all line endings like in first line',
						'cr+lf' => 'line endings for Windows or Dos',
						cr => ' convert line endings to the Mac standart',
						lf => 'convert line endings to the UNIX standart',
					},
					change => {
						back => 'switches to the last used document',
						prev => 'changes the current document one tab to the left',
						next => 'changes the current document one tab to the right',
					},
					readonly => {
						'as-attr' => 'turns write protection on if file is readonly',
						'on' => 'disables every modification of this document',
						off => 'makes document always editable even if it can\'t be saved',
					},
					syntaxmode => {
						auto => 'select syntaxmode depending on fileending',
						none => 'turn any syntaxmode settings off',
						ada => 'activate language settings for Ada',
						as => 'activate settings for Macromedia Actionscript',
						asm => 'language settings for Assembler',
						c => 'settings for the C / C++ language family',
						conf => 'for Apache Conf styled configuration files',
						context => 'settings for the ConTeXt Tex Macros',
						cs => 'syntaxmode for Microsoft C-Sharp',
						css => 'syntaxmode for Cascading Style Sheet language',
						eiffel => 'Bertrand Meyers objectoriented language Eiffel',
						forth => 'language of the Forth systems',
						fortran => 'syntaxmode of the FORmula TRANslation language',
						html => 'syntaxmode for the HyperText Markup Language',
						idl => 'syntaxmode of the Interface Definition Language',
						java => 'Settings for Sun\'s Java language',
						js => 'syntaxmode for Javascript',
						latex => 'syntaxmode for the LaTeX Tex macros',
						lisp => 'LISt Prozessor settings',
						lua => 'syntaxmode for the embedding language Lua',
						nsis => 'language of the Nullsoft Scriptable Install System',
						pascal => 'Niklaus Wirth\'s structured language Pascal',
						perl => 'syntaxmode for Larry Walls Perl',
						php => 'Rasmus Lehrdorf PHP Hypertext Prozessors',
						ps => 'Adobe\'s document desciption language Postscript',
						python => 'Guido van Rossums dynamic language Python',
						ruby => 'Yukihiro "Matz" Matsumoto\'s full objectoriented language',
						scheme => 'syntaxmode of the MIT LISP dialect',
						sh => 'settings for the UNIX Bourne Shell',
						sql => 'Structured Query Language originated from IBM',
						tcl => 'Tool Command Language from John Ousterhout',
						tex => 'Donald E. Knuth macro language for type setting',
						vb => 'settings for Microsoft Visual Basic',
						vbs => 'settings for Microsoft Visual Basic Script',
						xml => 'syntaxmode for the eXtensible Markup Language',
						yaml => 'syntaxmode for Indy\'s YAML Ain\'t Markup Language',
					},
					tabs => {
						hard => 'insert a tab while hitting the tab key',
						soft => 'insert several whitespaces while hitting tab key',
						'use' => 'use tabs (hard tabs) or whitespaces (soft tabs)',
						width => {
							2 => 'set width of tabs to an equal of 2 characters',
							3 => 'set width of tabs to an equal of 3 characters',
							4 => 'set width of tabs to an equal of 4 characters',
							5 => 'set width of tabs to an equal of 5 characters',
							6 => 'set width of tabs to an equal of 6 characters',
							8 => 'set width of tabs to an equal of 8 characters',
						},
					},
				},
				view => {
					dialog => {
						find => 'open dialog for text search and settings',
						replace => 'open dialog for find and replace text',
						info => 'version numbers, authors, credits, license',
						keymap => 'lists which key kombination triggers which function',
					},
					documentation => {
						credits => 'list of all involved people',
						'feature-list' => 'thematically sorted description of all functionalities',
						'navigation-guide' => 'explanations of the user interface',
						welcome => 'first steps: how to get help and give feedback',
						'this-version' => 'new features and important changes of the current version',
					},
					editpanel => {
						EOL => 'switch visibility of the end of line marker',
						'caret-line' => 'highlights row where caret(textcursor) is located',
						font => 'change font family, size, style etc.',
						'indention-guide' => 'vertical dotted lines in intervals of tab width',
						'line-wrap' => 'breaks long lines on window edge only visually',
						'right-margin' => 'shows straight vertical line on seleted width',
						whitespace => 'set whitespaces and tabs visible as dots and arrows',
						contextmenu => {
							custom => 'aktivate customizable editpanel context menu',
							default => 'aktivate default scintilla context menu',
							'no' => 'deaktivate all editpanel context menu',
						},
						margin => {
							marker => 'margin for bookmarks, marker, debug steps ...',
							'line-number' => 'sets line numbers visible',
							text => {
								0 => 'set extra margin on both sides of textfield to 0 pixel',
								1 => 'set extra margin on both sides of textfield to 1 pixel',
								2 => 'set extra margin on both sides of textfield to 2 pixel',
								4 => 'set extra margin on both sides of textfield to 4 pixel',
								6 => 'set extra margin on both sides of textfield to 6 pixel',
								8 => 'set extra margin on both sides of textfield to 8 pixel',
								10 => 'set extra margin on both sides of textfield to 10 pixel',
								12 => 'set extra margin on both sides of textfield to 12 pixel',
							},
						},
					},
					statusbar => 'switch visibility of the statusbar on bottom of the window',
					'statusbar-contexmenu' => 'enable or disable context menus on statusbar',
					tabbar => 'switch visibility of the tabbar, toolbar for doc selection',
					toolbar => {
						main => 'switch visibility of the main toolbar',
						search => 'toolbar with text seach and navigation functions',
						'search-goto' => 'goto searchbar and use find function',
					},
					'window-stay-on-top' => 'application window remains always visible',
				},
				config => {
					'app-lang' => {
						english => 'change user interface language to english',
						'deutsch-iso' => 'change user interface language to german (ISO)',
						'deutsch-utf' => 'change user interface language to german (UTF)',
						deutsch => 'change user interface language to german',
						'cesky-utf' => 'change user interface language to czech',
					},
					file => {
						global => {
							'open' => 'open file with current global configurations',
							reload => 'reload current global configuration file',
							'load-from' => 'load global configs from chosen file',
							'load-backup' => 'load global configs from backup',
							'load-defaults' => 'load default global configs',
							merge => 'merge current global configs with settings in this file',
							save => 'save current global configs into the file we load from',
							'save-as' => 'save current global configs into this file',
						},
						interface => {
							commandlist => 'definition for function calls, key binding, icons',
							menubar => 'open definition file for the menubar',
							contextmenu => 'open definition file for all contextmenu',
							maintoolbar => 'open definition file for the main toolbar',
							searchbar => 'open definition file for the searchbar',
							statusbar => 'open definition file for the statusbar',
						},
						localisation => {
							english => 'open english translation of application label texts',
							deutsch => 'open german translation of the application texts',
							'deutsch-iso' => 'open german translation with ISO charset',
							'deutsch-utf' => 'open german translation with UTF16 charset',
							'cesky-utf' => 'open czech translation with UTF16 charset',
						},
						syntaxmode => {
							ada => 'open file with settings for the Ada language',
							as => 'open file with Macromedia Actionscript settings',
							asm => 'open file with language settings for Assembler',
							c => 'open file with settings for the C / C++  languages',
							conf => 'settings for files in the Apache Conf style',
							context => 'settings for ConTeXt Tex Macros',
							cs => 'open file with syntaxmode for Microsoft C-Sharp',
							css => 'settings for the Cascading Style Sheet language',
							eiffel => 'Bertrand Meyers object oriented languagee Eiffel',
							forth => 'settings for the language of the Forth systems',
							fortran => 'syntaxmode von FORmula TRANslation open',
							html => 'syntaxmode for HyperText Markup Language open',
							idl => 'syntaxmode der Interface Definition Language open',
							java => 'open settings for Sun\'s Java language',
							js => 'open syntaxmode for Javascript',
							latex => 'open syntaxmode for the Tex macros named LaTeX',
							lisp => 'open settings for the almighty LISt Prozessor',
							lua => 'settings for the extension language Lua',
							nsis => ' language of the Nullsoft Scriptable Install System',
							pascal => 'settings for Niklaus Wirth\'s procedural language Pascal',
							perl => 'file with syntaxmode for Larry Walls Perl',
							php => 'Rasmus Lehrdorf PHP Hypertext Prozessor',
							ps => 'Adobe document description language Postscript',
							python => 'Guido van Rossums dynamic language Python',
							ruby => 'Yukihiro "Matz" Matsumoto\'s full object oriented Ruby',
							scheme => 'open syntaxmode of the MIT LISP dialect Scheme',
							sh => 'open settings for the UNIX Bourne Shell',
							sql => 'Structured Query Language, originated from IBM',
							tcl => 'Tool Command Language from John Ousterhout',
							tex => 'Donald E. Knuth\'s macro language for typesetting',
							vb => 'open file with settings for Microsoft Visual Basic',
							vbs => 'open file with settings for Microsoft Visual Basic Script',
							xml => 'open settings for die eXtensible Markup Language',
							yaml => 'open settings for Indy\'s YAML Ain\'t Markup Language',
						},
					},
					templates => 'open file with the current template definitions',
				},
			},
		},
		dialog => {
			config_file => {
				load =>'load configuration from the file :',
				save => 'store current program configuration into the file :',
			},
			edit => {
				goto_line_headline => 'goto line',
				goto_line_input => 'choose linenumber :',
				wrap_custom_headline => 'custom word wrapping',
				wrap_width_input => 'choose new line width (maximum number of chars) :',
			},
			error => {
				general => 'Error',
				no_param => 'called without needed parameters',
				file => 'file handling error',
				file_find => "can't find file :",
				file_read => "can't read file :",
				file_write => "can't write file :",
				config_read => "can't read config file :",
				config_parse => 'file has no data :',
				write_protected => 'This file is write protected by the file system.',
				write_protected2 => 'Please unlock this or save this text under an other filename.',
			},
			file => {
				files => 'Files',
				'open' => 'Open File',
				insert => 'Insert File',
				save_as => 'Save File As',
				save_all => 'Save All',
				save_none => 'Save None',
				save_copy_as => 'Save A Copy Of This File As',
				overwrite => 'Overwrite Existing File !',
				close_unsaved => 'Closing Unsafed File',
				save_current => 'Save Current File ?',
				save_open => 'Save All Open Files ?',
				quit_unsaved => 'Closing Unsafed Files :',
				open_session => 'Open File Session',
				add_session => 'Add File Session',
				save_session => 'Save Current File Session',
				import_session => 'Import File Session',
				export_session => 'Export File Session',
			},
			general => {
				apply => 'Apply',
				save => 'Save',
				overwrite => 'Overwrite',
				restore => 'Restore',
				cancel => 'Cancel',
				'close' => 'Close',
				all => 'All',
				'select' => 'Select',
				selected => 'Selected',
				none => 'None',
				dont_allow => 'Your settings dont allow this.',
			},
			help => {},
			info => {
				title => 'Info about',
				mady_by => 'by',
				licensed => 'licensed under',
				detail => 'see under help > license for credits and',
				more => 'explicit licenses',
				homepage => 'for more info visit',
				contains => 'this version contains',
				'and' => 'and',
				wrappes => 'which wrappes',
				extra => 'extra Perl Modules',
				dedication => 'Deditcated to all people who ever tried to write an editor.',
			},
			keyboard_map => {
				title => 'Keyboard Map',
			},
			search => {
				title => 'Find and Replace',
				confirm => {
					title => 'Replace With Confirmation',
					text => 'Replace This ?',
				},
				label => {
					search_for => 'Search for :',
					replace_with => 'Replace with :',
					case => 'Match Case',
					word_begin => 'Word Begin',
					whole_word => 'Whole Word Only',
					regex => 'Regular Expression',
					auto_wrap => 'Auto Wrap',
					incremental => 'Incremental Search',
					search_in => 'Search in',
					selection => 'Selection',
					document => 'Current Doc',
					open_documents => 'Open Docs',
					search => 'Find',
					replace_all => 'Replace All',
					with_confirmation => 'With Confirmation',
				},
				hint => {
					match_case => 'differ between UPPER and lower case',
					match_word_begin => 'match only beginnins of words',
					match_whole_word => 'match only whole words',
					match_regex => 'evaluates simple regular expression',
					incremental => 'search as you type',
					auto_wrap => 'jumpes between file endings',
					forward => 'find next',
					backward => 'find previous',
					fast_forward => 'find fast forward',
					fast_backward => 'find fast backward',
					document_start => 'find first in document',
					document_end => 'find last In document',
					replace_forward => 'replace and find next',
					replace_backward => 'replace and find previous',
				},
			},
			settings => {
				title => 'Configuration Dialog',
				panel => {
					general => 'General',
					edit => 'Edit Panel',
					files => 'Files',
				},
			},
		},
		key => {
			back => 'Back',
			esc => 'Esc',
			enter => 'Enter',
			del => 'Del',
			left => 'Left',
			right => 'Right',
			up => 'Up',
			down => 'Down',
			pgup => 'Page Up',
			pgdn => 'Page Down',
			space => 'Space',
			tab => 'Tab',
			meta => {
				alt => 'Alt',
				'shift' => 'Shift',
				ctrl => 'Ctrl',
			},
		},
	}
}


sub drop_xp_style_file{
 my $file    = shift;
 my $content = <<EOD;
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 <assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">
	 <assemblyIdentity
		 processorArchitecture="x86"
		 version="5.1.0.0"
		 type="win32"
		 name="Controls"
	 />
	 <description>MOM Client Application</description>
	 <dependency>
		 <dependentAssembly>
			 <assemblyIdentity
				 type="win32"
				 name="Microsoft.Windows.Common-Controls"
				 version="6.0.0.0"
				 publicKeyToken="6595b64144ccf1df"
				 language="*"
				 processorArchitecture="x86"
		 />
	 </dependentAssembly>
	 </dependency>
 </assembly>
EOD

	open my $FILE, ">$file" or Kephra::Dialog::warning_box(undef,
			$Kephra::localisation{'dialogs'}{'error'}{'file_write'}." $file",
			$Kephra::localisation{'dialogs'}{'error'}{'file'});
	print $FILE $content;
}

1;
